/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWVersion;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSOperation;
import filenet.ws.api.WSPort;
import filenet.ws.listener.axis.SOAPMessageUtils;
import filenet.ws.listener.axis.WSProcessor;
import filenet.ws.listener.axis.rm.WSRMCallbackData;
import filenet.ws.listener.axis.rm.WSRMSequenceInfo;
import filenet.ws.listener.axis.rm.WSRMUtils;
import filenet.ws.listener.utils.Constants;
import filenet.ws.listener.utils.VWSessionManager;
import filenet.ws.listener.utils.WSDLManager;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.P8BPMSoapActionURI;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.WSLogger;
import filenet.ws.utils.WSOperationInfoHelper;
import filenet.ws.utils.WSSchemaValidator;
import filenet.ws.utils.WSSchemaValidatorResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.transport.http.HTTPConstants;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorHandler
extends BasicHandler {
    private static final long serialVersionUID = 464L;
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis");
    protected static Logger requestLogger = Logger.getLogger("filenet.ws.listener.http.request");
    protected static final String m_className = "ValidatorHandler";
    private static long theInstanceCount = 0L;
    private static Object synchObj = new Object();

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 17:38:46  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.50  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long incrementCount() {
        Object object = synchObj;
        synchronized (object) {
            return ++theInstanceCount;
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        String m_method = "invoke";
        logger.entering(m_className, "invoke");
        int m_WSDLVersion = 30;
        P8BPMSoapActionURI soapActionURI = null;
        MessageContext m_msgContext = msgContext;
        WSLogger m_wsLogger = null;
        try {
            WSRMCallbackData rmCallbackData;
            WSBindingOperation SOAPOp;
            WSPort m_port;
            WSDefinition wsdl;
            String workspaceId;
            VWVersion vwVersion;
            String operation;
            String portType;
            String wcName;
            String m_soapURI;
            Message msg;
            String m_cpName;
            String m_ceURI;
            WSListenerProperties m_props;
            WSRMSequenceInfo seqInfo;
            boolean bRMMessage;
            block71: {
                int rmMsgType = WSRMUtils.getRMMessageType(msgContext);
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "rmMsgType = " + rmMsgType);
                }
                bRMMessage = WSRMUtils.hasRMHeaders(msgContext);
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "isRMMessage = " + bRMMessage);
                    logger.finest(m_className, "invoke", "isRMSequenceMessage = " + WSRMUtils.isRMSequenceMessage(msgContext));
                    logger.finest(m_className, "invoke", "SOAPActionURI = " + msgContext.getSOAPActionURI());
                }
                if (WSRMUtils.isRMSequenceMessage(msgContext)) {
                    return;
                }
                seqInfo = null;
                HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                if (req == null) {
                    throw new VWException("filenet.ws.listener.axis.ValidatorHandler.invalidState", "Invalid Invocation:  Should be a post.");
                }
                String m_listenerLocalHost = (String)req.getAttribute("P8BPM.listener.local.host");
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "Got my listener local host:" + m_listenerLocalHost);
                }
                msgContext.setProperty("MC.P8BPM.LISTENER.LOCALHOST", (Object)m_listenerLocalHost);
                m_props = (WSListenerProperties)req.getAttribute("P8BPM.wsListenerProperties");
                if (m_props == null) {
                    throw new VWException("filenet.ws.listener.axis.ValidatorHandler.noProperties", "Invalid Invocation:  Listener properties are not set.");
                }
                msgContext.setProperty("MC.P8BPM.LISTENERPROPERTIES", (Object)m_props);
                m_wsLogger = this.setupWSLogger(msgContext);
                m_ceURI = m_props.getProperty("filenet.pe.bootstrap.ceuri");
                m_cpName = (String)req.getAttribute("P8BPM.wsCurrentCPName");
                if (m_cpName == null) {
                    m_cpName = m_props.getProperty("cm.router");
                }
                msgContext.setProperty("MC.P8BPM.CONNECTIONPOINT", (Object)m_cpName);
                msg = msgContext.getRequestMessage();
                m_soapURI = msgContext.getSOAPActionURI();
                if (requestLogger.isFinest()) {
                    requestLogger.finest(m_className, "invoke", m_soapURI);
                }
                if (m_soapURI.contains("addressing/fault")) {
                    SOAPHeader hdr;
                    m_props.refresh();
                    String faultDescription = null;
                    SOAPBody body = msg.getSOAPBody();
                    if (body.hasChildNodes()) {
                        NodeList nl = body.getChildNodes();
                        int size = nl.getLength();
                        for (int i = 0; i < size; ++i) {
                            Node n = nl.item(i);
                            if (!n.getLocalName().equals("Fault")) continue;
                            String faultCode = null;
                            String faultString = null;
                            String faultDetail = null;
                            Node childN = VWXMLWrapper.getNodeNamed(n, "faultcode");
                            if (childN != null) {
                                faultCode = childN.toString();
                            }
                            if ((childN = VWXMLWrapper.getNodeNamed(n, "faultstring")) != null) {
                                faultString = childN.toString();
                            }
                            if ((childN = VWXMLWrapper.getNodeNamed(n, "detail")) != null) {
                                faultDetail = childN.toString();
                            }
                            StringBuilder b = new StringBuilder();
                            if (faultCode != null) {
                                b.append(faultCode);
                            }
                            if (faultString != null) {
                                b.append(faultString);
                            }
                            if (faultDetail != null && faultDetail.trim().length() > 0) {
                                b.append(faultDetail);
                            }
                            faultDescription = b.toString();
                        }
                    }
                    if (faultDescription != null && (hdr = msg.getSOAPHeader()) != null) {
                        String wobNum;
                        Node fdNode = VWXMLWrapper.getNodeNamed((Node)hdr, "FaultDetail");
                        if (fdNode != null) {
                            faultDescription = faultDescription + "," + fdNode.toString();
                        }
                        if ((wobNum = VWXMLWrapper.getNodeValue((Node)hdr, "RelatesTo")) != null) {
                            if (m_wsLogger != null) {
                                m_wsLogger.setType("Addressing Fault!");
                                m_wsLogger.append("SOAPAction=").append(m_soapURI).eoln();
                                m_wsLogger.append("WorkObject Number=").append(wobNum).eoln();
                                m_wsLogger.append("Fault=").append(faultDescription).eoln();
                            }
                            m_wsLogger.toString();
                        }
                    }
                    msgContext.setPastPivot(true);
                    return;
                }
                String wpsSoapActionTemplate = "P8_SVC_NAME%09P8_REGNUM%09P8_WSID%09P8_WCID%09P8_WSTIMESTAMP";
                String m_inMsg = null;
                boolean fromWPS = false;
                if (m_soapURI != null && m_soapURI.contains("P8_SVC_NAME%09P8_REGNUM%09P8_WSID%09P8_WCID%09P8_WSTIMESTAMP")) {
                    fromWPS = true;
                    m_inMsg = this.getInputMessageAsString(msgContext);
                    if (m_inMsg != null) {
                        if (logger.isFinest()) {
                            logger.finest(m_className, "invoke", "Initial input=" + m_inMsg);
                        }
                        String BEG = "[WPSCORRID::";
                        String END = "::WPSCORRID]";
                        int i = m_inMsg.indexOf("[WPSCORRID::");
                        int j = m_inMsg.lastIndexOf("::WPSCORRID]");
                        if (i != -1 && j != -1) {
                            String s = m_inMsg.substring(i + "[WPSCORRID::".length(), j);
                            m_soapURI = m_soapURI.replace("P8_SVC_NAME%09P8_REGNUM%09P8_WSID%09P8_WCID%09P8_WSTIMESTAMP", s);
                            m_inMsg = m_inMsg.substring(0, i) + m_inMsg.substring(j + "::WPSCORRID]".length());
                            msgContext.setProperty("MC.P8BPM.INMSG", (Object)m_inMsg);
                            if (logger.isFinest()) {
                                logger.finest(m_className, "invoke", "New SOAP Action=" + m_soapURI + ", " + m_inMsg);
                            }
                        }
                    }
                }
                soapActionURI = new P8BPMSoapActionURI(m_soapURI);
                m_WSDLVersion = soapActionURI.getWSDLVersion();
                wcName = soapActionURI.getWorkClassName();
                portType = soapActionURI.getPortType();
                operation = soapActionURI.getOperation();
                vwVersion = soapActionURI.getVWVersion();
                if (vwVersion == null) {
                    logger.finest(m_className, "invoke", "Null VWVersion!");
                    throw new VWException("filenet.ws.listener.axis.ValidatorHandler.No VWVersion!", "Invalid Invocation:  No VW Version.");
                }
                workspaceId = Integer.toString(vwVersion.getWorkSpaceId());
                wsdl = null;
                m_port = null;
                SOAPOp = null;
                if (fromWPS) {
                    wsdl = (WSDefinition)WSDLManager.getWorkClassWSDLorWF(wcName, vwVersion.getWorkSpaceId(), m_props, false, m_cpName);
                    m_port = wsdl.getDefaultPort(portType);
                    SOAPOp = m_port.getBindingOperation(operation);
                    try {
                        String soapActionFromWSDL;
                        if (SOAPOp != null && (soapActionFromWSDL = SOAPOp.getSoapAction()) != null) {
                            P8BPMSoapActionURI sa = new P8BPMSoapActionURI(soapActionFromWSDL);
                            soapActionURI.setOnlineId(sa.getOnlineId());
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isFinest()) break block71;
                        logger.throwing(m_className, "invoke", e);
                    }
                }
            }
            msgContext.setProperty("MC.P8BPM.SOAPACTIONURI", (Object)soapActionURI);
            boolean isReplying = soapActionURI.isReply();
            String mypath = "/wscp" + WSConstants.UTF8Encode(m_cpName) + "/wc/" + WSConstants.UTF8Encode(wcName) + "/" + workspaceId;
            msgContext.setProperty("MC.P8BPM.CURRENTPATH", (Object)mypath);
            this.checkEmptySOAPBody((SOAPMessage)msg, msgContext, m_WSDLVersion);
            if (bRMMessage && (rmCallbackData = (WSRMCallbackData)((Object)msgContext.getProperty("MC.P8BPM.RM.CALLBACK.DATA"))) != null) {
                String seqId = rmCallbackData.getSequenceId();
                seqInfo = WSRMSequenceInfo.getSequenceInfoBySeqId(seqId);
            }
            if (m_wsLogger != null) {
                StringBuilder type = new StringBuilder();
                String instanceId = System.currentTimeMillis() + "_" + ValidatorHandler.incrementCount();
                msgContext.setProperty("MC.P8BPM.WSLOGGER.INSTANCEID", (Object)instanceId);
                if (isReplying) {
                    type.append("WS-Listener[").append(instanceId).append("] reply-handling ");
                } else {
                    type.append("WS-Listener[").append(instanceId).append("] receive ");
                }
                type.append("WCName=").append(wcName);
                type.append(",PT=").append(portType);
                type.append(",Op=").append(operation);
                type.append(",WSId=").append(vwVersion.getWorkSpaceId());
                type.append(",WCId=").append(vwVersion.getWorkClassId());
                m_wsLogger.setType(type.toString());
                m_wsLogger.append("SOAPAction=").append(m_soapURI).eoln();
                StringBuffer buf = SOAPMessageUtils.exploreMessage((SOAPMessage)msg);
                m_wsLogger.append("SOAPMessage=").append(buf).eoln();
                m_wsLogger.append("Attachment Count=").append(Integer.toString(msg.countAttachments())).eoln();
            }
            if (WSProcessor.checkSynchronousSOAPAction(soapActionURI, msgContext)) {
                msgContext.setPastPivot(true);
                return;
            }
            m_props.refresh();
            VWSession vwSession = m_props.getVWSession(m_cpName);
            int myRegion = vwSession.getIsolatedRegion();
            int theirRegion = -1;
            theirRegion = isReplying ? soapActionURI.getReplyRegionNumber() : vwVersion.getIsolatedRegion();
            if (theirRegion != -1 && theirRegion != myRegion) {
                throw new VWException("filenet.ws.listener.axis.ValidatorHandler.mismatchedRegion", "Invalid Invocation:  Isolated Region is invalid.");
            }
            this.getInputMessageAsString(msgContext);
            msgContext.setProperty("MC.P8BPM.VWSESSION", (Object)vwSession);
            if (isReplying) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "Stop since this is a Receive for Reply.");
                }
                return;
            }
            if (wsdl == null) {
                wsdl = (WSDefinition)WSDLManager.getWorkClassWSDLorWF(wcName, vwVersion.getWorkSpaceId(), m_props, false, m_cpName);
            }
            if (m_port == null) {
                m_port = wsdl.getDefaultPort(portType);
            }
            if (SOAPOp == null) {
                SOAPOp = m_port.getBindingOperation(operation);
            }
            if (SOAPOp == null || !SOAPOp.isSoapBinding()) {
                throw new VWException("filenet.ws.listener.axis.WValidatorHandler.unsupportedBinding", "Unsupported binding.");
            }
            WSOperation m_op = wsdl.getOperation(portType, operation);
            WSOperationInfoHelper opInfoHelper = WSOperationInfoHelper.getWSOperationInfoHelper(m_op);
            if (opInfoHelper != null) {
                msgContext.setProperty("MC.P8BPM.OPINFO.HELPER", (Object)opInfoHelper);
            }
            if (this.checkSecurityHeader(opInfoHelper, msgContext)) {
                String username = (String)msgContext.getProperty("MC.P8BPM.USERNAME");
                String pw = (String)msgContext.getProperty("MC.P8BPM.PASSWORD");
                if (m_wsLogger != null) {
                    m_wsLogger.append("AuthUser=" + username);
                }
                try {
                    vwSession = VWSessionManager.getVWSessionAndVerify(username, pw, m_cpName, m_ceURI);
                    msgContext.setProperty("MC.P8BPM.VWSESSION", (Object)vwSession);
                    if (logger.isFinest()) {
                        logger.finest(m_className, "invoke", "successfully logon for a new user:" + username + ", cp=" + m_cpName);
                    }
                }
                catch (Exception e) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, "invoke", "Failed to logon for a new user:" + username + ", cp=" + m_cpName);
                    }
                    String s = e.getLocalizedMessage();
                    QName fault = WSConstants.getWSConstants((int)m_WSDLVersion).FAULT_INVALID_INVOCATION;
                    AxisFault retFault = new AxisFault(fault, "VWException: Unauthorized", null, null);
                    retFault.addFaultDetail(fault, WSConstants.UTF8Encode(s));
                    logger.throwing(m_className, "invoke", retFault);
                    throw retFault;
                }
            }
            boolean rmWaitForResponse = false;
            if (m_op.getOutMessage() != null || m_op.getFaults() != null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "Has output or fault... check for ReplyHeader..");
                }
                if (!this.checkReplyHeader(msgContext, m_WSDLVersion)) {
                    soapActionURI.setSync();
                    String replyHeaderString = this.getReplyHeader(m_props.getProperty("listener.base.url"), soapActionURI.toStringEx(), (String)msgContext.getProperty("MC.P8BPM.LISTENER.LOCALHOST"), (String)msgContext.getProperty("MC.P8BPM.WSLOGGER.INSTANCEID"), (String)msgContext.getProperty("MC.P8BPM.CONNECTIONPOINT"), m_WSDLVersion);
                    if (m_wsLogger != null) {
                        m_wsLogger.append("SYNC_WAIT, REPLY_HEADER=" + replyHeaderString);
                    }
                    msgContext.setProperty("MC.P8BPM.REPLYHEADER", (Object)replyHeaderString);
                    msgContext.setProperty("MC.P8BPM.ISSYNC", (Object)Boolean.TRUE);
                    if (bRMMessage) {
                        msgContext.setProperty("MC.P8BPM.RM.HAS.RESPONSE", (Object)Boolean.TRUE);
                        rmWaitForResponse = true;
                    }
                } else {
                    msgContext.setProperty("MC.P8BPM.ISSYNC", (Object)Boolean.FALSE);
                }
            }
            if (bRMMessage && seqInfo != null) {
                seqInfo.setWaitForResponse(rmWaitForResponse);
            }
        }
        catch (AxisFault x) {
            if (m_wsLogger != null) {
                m_wsLogger.append("AXIS FAULT=" + x.toString());
            }
            throw x;
        }
        catch (Throwable e) {
            String s = e.getLocalizedMessage();
            if (logger.isFinest()) {
                logger.throwing(m_className, "invoke", e);
            }
            QName fault = WSConstants.getWSConstants((int)m_WSDLVersion).FAULT_INVALID_INVOCATION;
            AxisFault retFault = new AxisFault(fault, WSConstants.UTF8Encode(s), null, null);
            retFault.addFaultDetail(fault, WSConstants.UTF8Encode(s));
            logger.throwing(m_className, "invoke", retFault);
            if (m_wsLogger != null) {
                m_wsLogger.append("THROWABLE=").append((Object)retFault).eoln();
            }
            throw retFault;
        }
        finally {
            logger.exiting(m_className, "invoke");
            if (m_wsLogger != null) {
                m_wsLogger.print("ValidatorHandler Exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSecurityHeader(WSOperationInfoHelper opInfoHelper, MessageContext msgContext) throws Exception {
        String m_method = "checkSecurityHeader";
        try {
            logger.entering(m_className, m_method);
            if (opInfoHelper == null || msgContext == null) {
                boolean bl = false;
                return bl;
            }
            boolean checkSecurity = opInfoHelper.getAuthentication();
            Message msg = msgContext.getRequestMessage();
            if (checkSecurity) {
                SOAPHeader header;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Need to check for security soap header.");
                }
                if ((header = msg.getSOAPPart().getEnvelope().getHeader()) != null) {
                    SOAPElement pwElement;
                    Iterator iter = SOAPMessageUtils.getChildElementsForName((SOAPElement)header, WSConstants.QNAME_WSSE_SECURITY, true);
                    if (iter == null) {
                        logger.finest(m_className, m_method, "missing security");
                        throw Constants.EXCEPTION_NO_SECURITY_HEADER;
                    }
                    SOAPElement securityElement = (SOAPElement)iter.next();
                    if ((iter = SOAPMessageUtils.getChildElementsForName(securityElement, WSConstants.QNAME_WSSE_USERNAME_TOKEN, true)) == null) {
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "missing usernametoken");
                        }
                        throw Constants.EXCEPTION_NO_SECURITY_HEADER;
                    }
                    SOAPElement usernameTokenElement = (SOAPElement)iter.next();
                    if ((iter = SOAPMessageUtils.getChildElementsForName(usernameTokenElement, WSConstants.QNAME_WSSE_USERNAME, true)) == null) {
                        logger.finest(m_className, m_method, "missing username");
                        throw Constants.EXCEPTION_NO_SECURITY_HEADER;
                    }
                    SOAPElement usernameElement = (SOAPElement)iter.next();
                    String username = usernameElement.getValue();
                    String pw = "";
                    iter = SOAPMessageUtils.getChildElementsForName(usernameTokenElement, WSConstants.QNAME_WSSE_PASSWORD, true);
                    if (iter != null && (pw = (pwElement = (SOAPElement)iter.next()).getValue()) == null) {
                        pw = "";
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "username=" + username + ",pw=" + pw);
                    }
                    if (this.name != null && this.name.trim().length() == 0 || pw != null && pw.trim().length() == 0) {
                        throw Constants.EXCEPTION_INVALID_CREDENTIALS;
                    }
                    msgContext.setProperty("MC.P8BPM.USERNAME", (Object)username);
                    msgContext.setProperty("MC.P8BPM.PASSWORD", (Object)pw);
                    ((SOAPHeaderElement)securityElement).setProcessed(true);
                }
            }
            boolean bl = checkSecurity;
            return bl;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkReplyHeader(MessageContext msgContext, int m_WSDLVersion) throws Exception {
        String m_method = "checkReplyHeader";
        try {
            logger.entering(m_className, m_method);
            if (msgContext == null) {
                boolean bl = false;
                return bl;
            }
            Message msg = msgContext.getRequestMessage();
            SOAPHeader header = msg.getSOAPPart().getEnvelope().getHeader();
            if (header == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "No SOAP Header.");
                }
                boolean bl = false;
                return bl;
            }
            Iterator iter = SOAPMessageUtils.getChildElementsForName((SOAPElement)header, WSConstants.getWSConstants((int)m_WSDLVersion).QNAME_REPLYHEADER, true);
            if (iter == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "No SOAP Header:ReplyHeader.");
                }
                boolean bl = false;
                return bl;
            }
            SOAPElement replyHeaderElement = (SOAPElement)iter.next();
            String replyHeaderString = SOAPMessageUtils.getSOAPElementAsString(replyHeaderElement);
            msgContext.setProperty("MC.P8BPM.REPLYHEADER", (Object)replyHeaderString);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Got ReplyHeader = " + replyHeaderString);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private String getRealReplyBaseURL(String baseURL, String listenerLocalHost) {
        if (listenerLocalHost == null) {
            return baseURL;
        }
        String m_method = "getRealReplyBaseURL:" + baseURL + ":" + listenerLocalHost;
        try {
            URL url = new URL(baseURL);
            StringBuffer buf = new StringBuffer();
            buf.append(url.getProtocol()).append("://").append(listenerLocalHost).append(url.getPath());
            String query = url.getQuery();
            if (query != null) {
                buf.append("?").append(query);
            }
            String newBaseURL = buf.toString();
            try {
                url = new URL(newBaseURL);
                return newBaseURL;
            }
            catch (MalformedURLException e) {
                logger.severe(m_className, m_method, newBaseURL + " is not valid!");
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return baseURL;
    }

    private String getReplyHeader(String baseURL, String replySoapAction, String listenerLocalHost, String instanceId, String m_cpName, int m_WSDLVersion) {
        String myAddress = this.getRealReplyBaseURL(baseURL, listenerLocalHost) + "/wscp" + WSConstants.UTF8Encode(m_cpName) + "/SyncReply/" + instanceId;
        StringBuffer buf = new StringBuffer();
        buf.append("<ReplyHeader xmlns=\"").append(WSConstants.getWSConstants((int)m_WSDLVersion).P8BPM_NS_GENERIC).append("\">\n");
        buf.append("<ReplyTo xmlns=\"").append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\">\n");
        buf.append("<Address>").append(myAddress).append("</Address>\n");
        buf.append("<ReferenceProperties><ReplySOAPAction>\n").append(replySoapAction);
        buf.append("\n</ReplySOAPAction><ReplyVersion>").append(ValidatorHandler._get_FILE_REVISION()).append("</ReplyVersion></ReferenceProperties></ReplyTo></ReplyHeader>");
        String s = buf.toString();
        if (logger.isFinest()) {
            logger.finest(m_className, "getReplyHeader", s);
        }
        return s;
    }

    private String getInputMessageAsString(MessageContext msgContext) throws Exception {
        String m_inMsg = (String)msgContext.getProperty("MC.P8BPM.INMSG");
        if (m_inMsg != null) {
            return m_inMsg;
        }
        String m_method = "getInputMessageAsString";
        try {
            logger.entering(m_className, m_method);
            Message msg = msgContext.getRequestMessage();
            SOAPBody body = msg.getSOAPPart().getEnvelope().getBody();
            if (body == null) {
                throw new VWException("filenet.ws.listener.axis.P8BPMValidatorHandler.NoSOAPBody", "Missing SOAP body.");
            }
            if (body.hasFault()) {
                SOAPFault soapFault = body.getFault();
                String soapFaultAsString = SOAPMessageUtils.getSOAPElementAsString((SOAPElement)soapFault);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "FAULT: " + soapFaultAsString);
                }
                msgContext.setProperty("MC.P8BPM.FAULT", (Object)soapFault.getFaultCode());
                msgContext.setProperty("MC.P8BPM.INMSG", (Object)soapFault.getFaultString());
                String string = null;
                return string;
            }
            m_inMsg = SOAPMessageUtils.getBodyChildElementsAsString(body);
            if (m_inMsg == null) {
                throw new VWException("filenet.ws.listener.axis.P8BPMValidatorHandler.emptySOAPBodyElement", "Empty SOAP body element.");
            }
            msgContext.setProperty("MC.P8BPM.INMSG", (Object)m_inMsg);
            String string = m_inMsg;
            return string;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private void validateInputMessage(WSDefinition wsdl, String m_soapURI, String m_inMsg) throws VWException {
        String m_method = "validateInputMsg";
        if (m_inMsg == null) {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "null msg or WSDL, skip validating");
            }
            return;
        }
        try {
            logger.entering(m_className, m_method);
            WSSchemaValidatorResult res = WSSchemaValidator.validate(wsdl.getSchemasTNS(), m_soapURI, wsdl.getSchemas(), m_inMsg);
            if (!res.getValid()) {
                throw new VWException("filenet.ws.listener.axis.P8BPMValidatorHandler.FailedValidateInputMsg", res.toString());
            }
        }
        catch (Throwable e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException(e);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private WSLogger setupWSLogger(MessageContext m_msgContext) {
        WSLogger res;
        block5: {
            res = null;
            WSListenerProperties m_props = (WSListenerProperties)m_msgContext.getProperty("MC.P8BPM.LISTENERPROPERTIES");
            if (m_props == null) {
                return res;
            }
            try {
                m_props.refresh();
                String s = m_props.getProperty("filenet.ws.listener.tracing", "true");
                boolean b = new Boolean(s);
                if (!b) break block5;
                res = new WSLogger("WS-Listener");
                res.setTraceToFile(true);
                res.setFileName(m_props.getProperty("filenet.ws.listener.tracefile"));
                try {
                    res.setFileSize(Long.parseLong(m_props.getProperty("filenet.ws.listener.tracefilesize")));
                }
                catch (Exception e) {
                    // empty catch block
                }
                m_msgContext.setProperty("MC.P8BPM.WSLOGGER", (Object)res);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return res;
    }

    private void checkEmptySOAPBody(SOAPMessage msg, MessageContext m_msgContext, int m_WSDLVersion) {
        block6: {
            String m_method = "checkEmptySOAPBody";
            try {
                Iterator iter;
                SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
                SOAPBody body = env.getBody();
                boolean empty = true;
                if (body != null && (iter = body.getChildElements()) != null) {
                    while (iter.hasNext() && empty) {
                        Object o = iter.next();
                        if (!(o instanceof SOAPElement)) continue;
                        empty = false;
                    }
                }
                if (!empty) {
                    return;
                }
                body.addBodyElement(env.createName("placeholder", "fnpo", WSConstants.getWSConstants((int)m_WSDLVersion).P8BPM_NS_GENERIC));
                ServiceDesc serviceDesc = m_msgContext.getService().getServiceDescription();
                OperationDesc operation = serviceDesc.getOperationByName("process");
                if (operation != null) {
                    m_msgContext.setOperation(operation);
                }
            }
            catch (Exception e) {
                if (!logger.isFinest()) break block6;
                logger.finest(m_className, "checkEmptySOAPBody", e.getMessage());
            }
        }
    }
}

